/*
 * Decompiled with CFR 0.152.
 */
package rikka.lanserverproperties;

import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.ShareToLanScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.GameType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.apache.commons.lang3.tuple.Pair;
import rikka.lanserverproperties.OpenToLanScreenEx;

@Mod(value="lanserverproperties")
public class LanServerProperties {
    public static final String MODID = "lanserverproperties";
    public static LanServerProperties INSTANCE = null;

    public LanServerProperties() {
        if (INSTANCE != null) {
            throw new RuntimeException("Duplicated Class Instantiation: CustomItems");
        }
        INSTANCE = this;
        ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.DISPLAYTEST, () -> Pair.of(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (a, b) -> true));
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> ClientHandler::registerGuiEventHandler);
    }

    private static class LanServerStartButtonHandler
    implements Button.IPressable {
        public final ShareToLanScreen owner;

        private LanServerStartButtonHandler(ShareToLanScreen owner) {
            this.owner = owner;
        }

        public void onPress(Button theButton) {
            TranslationTextComponent itextcomponent;
            Minecraft mc = Minecraft.func_71410_x();
            mc.func_147108_a((Screen)null);
            int port = OpenToLanScreenEx.getServerPort((Screen)this.owner);
            String gameMode = (String)ObfuscationReflectionHelper.getPrivateValue(ShareToLanScreen.class, (Object)this.owner, (String)"field_146599_h");
            boolean allowCheats = (Boolean)ObfuscationReflectionHelper.getPrivateValue(ShareToLanScreen.class, (Object)this.owner, (String)"field_146600_i");
            if (mc.func_71401_C().func_195565_a(GameType.func_77142_a((String)gameMode), allowCheats, port)) {
                OpenToLanScreenEx.onOpenToLanSuccess((Screen)this.owner);
                itextcomponent = new TranslationTextComponent("commands.publish.started", new Object[]{port});
            } else {
                itextcomponent = new TranslationTextComponent("commands.publish.failed");
            }
            mc.field_71456_v.func_146158_b().func_146227_a((ITextComponent)itextcomponent);
            mc.func_230150_b_();
        }
    }

    private static class ClientHandler {
        private ClientHandler() {
        }

        public static void registerGuiEventHandler() {
            MinecraftForge.EVENT_BUS.addListener(ClientHandler::onGuiInit);
            MinecraftForge.EVENT_BUS.addListener(ClientHandler::onGuiDraw);
        }

        public static void onGuiInit(GuiScreenEvent.InitGuiEvent.Post event) {
            Screen gui = event.getGui();
            if (!(gui instanceof ShareToLanScreen)) {
                return;
            }
            Button button = null;
            String msg = I18n.func_135052_a((String)"lanServer.start", (Object[])new Object[0]);
            for (Widget widget : event.getWidgetList()) {
                if (!(widget instanceof Button) || !widget.func_230458_i_().getString().equals(msg)) continue;
                button = (Button)widget;
                break;
            }
            if (button == null) {
                System.out.println("[LSP] Unable to locate start server button!");
                return;
            }
            Field fieldOnPress = ObfuscationReflectionHelper.findField(Button.class, (String)"field_230697_t_");
            try {
                Field modifiersField = Field.class.getDeclaredField("modifiers");
                modifiersField.setAccessible(true);
                modifiersField.setInt(fieldOnPress, fieldOnPress.getModifiers() & 0xFFFFFFEF & 0xFFFFFFFD);
                modifiersField.setAccessible(false);
                fieldOnPress.set(button, new LanServerStartButtonHandler((ShareToLanScreen)gui));
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                e.printStackTrace();
            }
            FontRenderer textRenderer = (FontRenderer)ObfuscationReflectionHelper.getPrivateValue(Screen.class, (Object)gui, (String)"field_230712_o_");
            OpenToLanScreenEx.init(gui, textRenderer, event.getWidgetList(), arg_0 -> ((GuiScreenEvent.InitGuiEvent.Post)event).addWidget(arg_0));
        }

        public static void onGuiDraw(GuiScreenEvent.DrawScreenEvent.Post event) {
            Screen gui = event.getGui();
            if (!(gui instanceof ShareToLanScreen)) {
                return;
            }
            FontRenderer textRenderer = (FontRenderer)ObfuscationReflectionHelper.getPrivateValue(Screen.class, (Object)gui, (String)"field_230712_o_");
            OpenToLanScreenEx.postDraw(gui, textRenderer, event.getMatrixStack(), event.getMouseX(), event.getMouseY(), event.getRenderPartialTicks());
        }
    }
}

